	.INCLUDE "EQUATES.S"
****
*
* LOGIC BANK
*
* DUNGEON 2600 PROGRAM
*
* WRITTEN BY ADAM CLAYTON
* DEVELOPED BY SCULPTURED SOFTWARE
* COPYRIGHT 1987 ATARI
*
****
*
* BANK SWITCHING PORTION
*
****
	ORG	$FFE8
MBANK:
	LDA	$FFF7		;JUMP TO BANK 1 (MAZE BANK)
	JMP	LOGIC		;VECTOR FOR NORMAL BANK SWITCH
****
*
* JUMP FOR WRONG BANK
*
****
	ORG	$FFF0
LFIX:
	LDA	$FFF9		;JUMP TO BANK 3 (TITLE BANK)
JMP	LFIX
****
*
* RESET VECTORS
*
****
	ORG	$FFF8
	DC.B	$00,$00
	DC.W	LFIX	;IF WRONG BANK GOTO CORRECT ONE
	DC.W	LFIX
	DC.W	LFIX
  
	ORG	$F100
****
*
* SOUND TABLE
*
****
AUDTAB:
	DC.B	$00
	.MACRO	FV FRQ, VOL
	.DC.B	\VOL*$10&$E0|\FRQ
	.ENDM
KILL:
	DC.B	$3
	FV	$1F,$8
	FV	$18,$8
	FV	$12,$8
	FV	$0C,$6
	FV	$0D,$6
	FV	$0E,$4
	FV	$10,$4
	FV	$12,$2
	DC.B	$00
BULLET:
	DC.B	8
	FV	$04,6
	FV	$04,6
	FV	$04,6
	FV	$05,4
	FV	$05,4
	FV	$06,2
	DC.B	$00
PLAYERHIT:
	DC.B	$8
	FV	$1F,$F
	FV	$1E,$F
	FV	$1D,$F
	FV	$1C,$C
	FV	$1A,$C
	FV	$18,$8
	FV	$16,$6
	FV	$12,$4
	DC.B	$00
BOMB:
	DC.B	$8
	FV	$03,$F
	FV	$05,$F
	FV	$06,$F
	FV	$07,$C
	FV	$08,$C
	FV	$09,$A
	FV	$0A,$A
	FV	$0B,$8
	FV	$0C,$8
	FV	$0D,$8
	FV	$0E,$8
	FV	$0F,$6
	FV	$10,$4
	FV	$11,$2
	FV	$12,$2
	FV	$13,$1
	DC.B	$00
PICKUP:
	DC.B	$4
	FV	$08,8
	FV	$08,8
	FV	$08,8
	FV	$07,6
	FV	$07,6
	FV	$07,4
	FV	$06,4
	FV	$06,2
	DC.B	$00
****
*
* TABLES FOR VERTICAL BLANK KERNAL
*
****
SCORES:
	DC.B	$01,$02,$03,$05,$10
ENEMDRAN:
	DC.B	$01,$01,$02,$02,$04
HORIJOY:
	DC.B	$00,$00,$00,$00,$FF,$FE,$01,$02
	DC.B	$00,$00,$00,$00,$FF,$FE,$01,$02
	DC.B	$00,$00,$00,$00,$FF,$FE,$01,$02
	DC.B	$00,$00,$00,$00,$FF,$FE,$01,$02
AHOR:
	DC.B	$00,$00,$00,$00,$FD,$FC,$03,$04
	DC.B	$00,$00,$00,$00,$FD,$FC,$03,$04
	DC.B	$00,$00,$00,$00,$FD,$FC,$03,$04
	DC.B	$00,$00,$00,$00,$FD,$FC,$03,$04
AVER:
	DC.B	$00,$00,$00,$00,$00,$00,$00,$00
	DC.B	$00,$00,$00,$00,$00,$00,$00,$00
	DC.B	$FD,$FC,$FD,$FC,$FD,$FC,$FD,$FC
	DC.B	$03,$04,$03,$04,$03,$04,$03,$04
XMOV:
	DC.B	$00,$00,$F9,$07
	DC.B	$00,$00,$F9,$07,$00,$00,$F9,$07,$00,$00,$F9,$07
YMOV:
	DC.B	$00,$00,$00,$00
	DC.B	$00,$00,$00,$00,$F9,$F9,$F9,$F9,$07,$07,$07,$07
PLJOY:
	DC.B	$98,$98,$00,$08,$98,$98,$00,$08,$10,$10,$00,$08,$18,$18,$00,$08
DIRJOY:
	DC.B	$00,$00,$00,$00
	DC.B	$00,$1E,$16,$06,$00,$1C,$14,$04,$00,$18,$10,$00
PF0MSK:
	DC.B	$10,$20,$40,$80
	DC.B	$00,$00,$00,$00
PF2MSK:
	DC.B	$00,$00,$00,$00
	DC.B	$00,$00,$00,$00,$00,$00,$00,$00
	DC.B	$01,$02,$04,$08,$10,$20,$40,$80
PF1MSK:
	DC.B	$00,$00,$00,$00
	DC.B	$80,$40,$20,$10,$08,$04,$02,$01
	DC.B	$00,$00,$00,$00,$00,$00,$00,$00
PL:
	DC.B	$00,$01,$01,$02,$02,$01,$01,$00
	DC.B	$03,$04,$04,$05,$05,$04,$04,$03
	DC.B	$06,$07,$08,$07,$06,$09,$0A,$09
	DC.B	$0B,$0C,$0D,$0C,$0B,$0E,$0F,$0E
RSEED:
	DC.B	$08,$02,$10,$04
PLAYLEV:
	DC.B	$00,$03,$07
WHATODO:
	DC.B	$00,$02,$01,$02,$03,$03,$01,$04
	DC.B	$01,$01,$01,$05,$03,$04,$06,$04
ENTRYR:
	DC.B	$00,$01,$02,$04,$06,$08,$0A,$0D
	DC.B	$10,$13,$16,$19,$1C,$1F,$22,$25
	DC.B	$28,$2C,$30,$34,$38,$3C,$40,$44
	DC.B	$48,$4C
ENTRY:
	DC.B	$20,$E7,$20,$60,$20,$E7,$27,$20
	DC.B	$F3,$E0,$A7,$F4,$67,$60,$24,$60
	DC.B	$27,$42,$20,$27,$54,$20,$60,$27
	DC.B	$27,$20
ENTRYX:
	DC.B	$0C,$18,$30,$40,$58,$68,$80,$8C
EXITYP:
	DC.B	$00,$00
	DC.B	$03,$02,$03,$02,$03,$02,$03,$02
	DC.B	$04,$01,$05,$04,$01,$05
	DC.B	$04,$01,$05,$04,$01,$05,$04,$01,$05
	DC.B	$04,$01,$05,$04,$01,$05,$04,$01,$05
	DC.B	$04,$01,$05,$04,$01,$05
	DC.B	$06,$01,$01,$07,$06,$01,$01,$07
	DC.B	$06,$01,$01,$07,$06,$01,$01,$07
	DC.B	$06,$01,$01,$07,$06,$01,$01,$07
	DC.B	$06,$01,$01,$07,$06,$01,$01,$07
	DC.B	$06,$01,$01,$07,$06,$01,$01,$07
PREFTAB:
	DC.B	$08,$08,$08
VERTJOY:
	DC.B	$00,$00,$00,$00,$00,$00,$00,$00
	DC.B	$00,$00,$00,$00,$00,$00,$00,$00
	DC.B	$FF,$FE,$FF,$FE,$FF,$FE,$FF,$FE
	DC.B	$01,$02,$01,$02,$01,$02,$01,$02
EXIT0:	DC.B	$00,$00,$00,$00,$00,$00,$00,$00
EXIT1:	DC.B	$FF,$FF,$FF,$FF,$01,$01,$01,$01
EXIT2:	DC.B	$FF,$FF,$FF,$FF,$FF,$FF,$FF,$FF
EXIT3:	DC.B	$01,$01,$01,$01,$01,$01,$01,$01
EXIT4:	DC.B	$02,$02,$02,$02,$01,$01,$01,$01
EXIT5:	DC.B	$FF,$FF,$FF,$FF,$FE,$FE,$FE,$FE
EXIT6:	DC.B	$03,$03,$03,$03,$01,$01,$01,$01
EXIT7:	DC.B	$FF,$FF,$FF,$FF,$FD,$FD,$FD,$FD

YSTART:
	DC.B	$20,$60,$A0,$E0,$20,$60,$A0,$E0
XSTART:
	DC.B	$88,$88,$88,$88,$08,$08,$08,$08
ADDTAB:
	DC.B	$00,$06,$00
LUMLEV:
	DC.B	$0A,$08,$08,$06,$04,$04
MUTATE:
	DC.B	$00,$05,$07,$00,$01,$07,$0A,$00
	DC.B	$02,$09,$0A,$00,$04,$0C,$0C,$00
GENGUY:
	DC.B	$31,$41,$31,$41,$51,$31,$41,$51
	DC.B	$62,$52,$72,$62,$73,$63,$73,$73
GENSPEED:
	DC.B	$3F,$3E,$3C,$00,$1F,$1E,$1C,$00
	DC.B	$0F,$0E,$0C,$00,$07,$06,$08,$00
GETLO:
	DC.B	GEXIT2&$FF,GCHEST&$FF,GCHEST&$FF,GCHEST&$FF,GCHEST&$FF
	DC.B	GGUN&$FF,GGUN&$FF,GGUN&$FF,GTRAP&$FF,GTRAP&$FF
	DC.B	GFOOD&$FF,GBOMB&$FF,GKEY&$FF,GHOLE&$FF,GSTAIR&$FF
	DC.B	GEXIT2&$FF
GETHI:
	DC.B	GEXIT2/256,GCHEST/256,GCHEST/256,GCHEST/256,GCHEST/256
	DC.B	GGUN/256,GGUN/256,GGUN/256,GTRAP/256,GTRAP/256
	DC.B	GFOOD/256,GBOMB/256,GKEY/256,GHOLE/256,GSTAIR/256
	DC.B	GEXIT2/256
TRAPDRAN:
	DC.B	$06,$04
OBJSCLO:
	DC.B	$10,$50,$00,$00
OBJSCHI:
	DC.B	$00,$00,$01,$03
ATRIBUTE:
	DC.B	$80,$20,$40
	
****
*
* LOGIC BANK START LOCATION
*
****
LOGIC:
	LDX	#$FF
	TXS			;RESET STACK POINTER
	LDA	CONTRL		;FIRST THING, CHECK IF SPECIAL CASE
	BMI	.01   
	AND	#$0F
	BEQ	.Z
	CMP	#1
	BNE	.A
	JMP	CON1		;DEC COLORS FOR FADE OUT
.A:
	CMP	#3
	BNE	.BA
	JMP	CON3		;NEXT ROOM
.BA:
	CMP	#6
	BNE	.C
	JMP	CON6		;INC COLORS FOR FADE IN
.C:
	JMP	OVER  
.Z:	
	LDA	FRAME		;RUN SUBS FOR CURRENT FRAME COUNT
	CMP	#$00
	BNE	.1
	JSR	UPGUYS		;FRAME=0 UPDATE PLAYERS, WINDOW
.01:
	JSR	SETPLAY
	LDA	#$01
	STA	FRAME
	BNE	OVER
.1:
	CMP	#$01		;FRAME=1 MOVE PLAYERS
	BNE	.2
	JSR	STLEVEL 	;CHECK IF GUYS IN EXIT (MIGHT SET CONTROL)
	LDA	CONTRL
	AND	#$0F
	CMP	#$01		;CHECK IF FADE OUT STARTED
	BEQ	.01		;IF SO JUST CALL SETPLAY
	JSR	UPJOY
	LDA	#$02
	STA	FRAME
	BNE	OVER
.2:
	JMP	ENEMYUP 	;FRAME=2 MOVE 1/2 ENEMIES
OVER:
.3:
	INC	RANDOM		;WAIT TILL END OF TIMER
	LDA	INTIM
	BNE	.3
	STA	WSYNC
	LDA	#$42
	STA	VSYNC		;START VERTICAL SYNC
****
*
* PROGRAM TO HANDLE THE AUDIO OUTPUT
*
****
AUDIO:
	DEC	FRMCNT		;DO SOUND IN ONE LINE
	LDA	FRMCNT
	AND	#$01
	TAX
	LDA	#$00		
	LDY	CONTRL
	BMI	.3		;IF PAUSE ON ZERO VOLUME FOR THE TIME BRING
.1:
	LDY	SOUND0+SARA,X
	LDA	AUDTAB,Y
	BEQ	.3
	PHA
	INY
	TYA
	STA	SOUND0,X
	PLA
	CMP	#$10
	BCS	.2
	STA	AUDC0,X
	BCC	.4
.2:
	STA	AUDF0,X
	LSR
	LSR
	LSR
	LSR
.3:
	STA	AUDV0,X
.4:
	STA	WSYNC
****
*
* PROGRAM TO UPDATE AND PUT BALL ON SCREEN
* SHOULD RUN IN TWO LINES
**** 
UPBALL:
	LDA	FRMCNT		;3
	AND	#$01
	TAX
	LDA	BALCNT+1,X
	BEQ	.2
	CLC			;16
	ADC	#9
	SEC
	SBC	WINDOW
	BCC	.2		;22
	CMP	#80
	BCS	.2		;26
.1:
	STA	BALCNT
	LDA	HMBALL+1,X
	CLC
	ADC	#$03
	CMP	#160		;39
	BCC	.3
.2:
	STA	WSYNC
	LDA	#$FF
	STA	BALCNT
	LDA	#$33
	STA	HMBALL
	LDA	#$00
	STA	BALCNT+1,X
	STA	ADIR,X
	BEQ	.5		;SHORT PATH
.3:
	STA	HMBALL		;45
* UPDATE BALL POSITIONS IF PAUSE CLEAR
	LDA	CONTRL
	BPL	.4
	STA	WSYNC
	BMI	.5
.4:
	LDA	ADIR,X
	AND	#$0F
	ASL
	LDY	HEALTH,X	;CHECK GUN BIT
	BPL	.41
	ORA	#$01
.41:
	TAY
	LDA	AHOR,Y
	CLC
	ADC	HMBALL+1,X
	STA	HMBALL+1,X	;73
	LDA	AVER,Y
	CLC
	ADC	BALCNT+1,X
	STA	BALCNT+1,X
.5:
	STA	WSYNC
	LDA	#$00
	STA	VSYNC
	LDA	#$42
	STA	VBLANK
	LDA	#90
	STA	TIM64T
	JMP	MBANK		;GOTO PLAYFIELD BANK
*
* PROGRAM TO SET UP PLYTAB
*
SETPLAY:
	LDA	WINDOW		;GET HIGH NIBBLE OF WINDOW
	AND	#$F0
	STA	TEMP+1		;STORE IN TEMP+1
	LDY	#$00
	STY	TEMP		;CLEAR LINE #
	STY	TEMP+3		;CLEAR NUMBER IN LINE
	LDX	#$09
.01:
	LDA	PLVER+SARA,X	;DO FIRST LINE
	BEQ	.03
	SEC
	SBC	TEMP+1
	BCS	.02
	EOR	#$FF
	ADC	#$01
.02:
	CMP	#16
	BCC	.04
.03:
	DEX
	BPL	.01
	BMI	.31
.04:
	TXA
	STA	PLYTAB,Y
	INY
	INC	TEMP+3
	BNE	.03
.1:
	LDA	#$00
	STA	TEMP+3
	LDX	#$09
.2:
	LDA	PLVER+SARA,X
	BEQ	.3
	AND	#$F0
	CMP	TEMP+1
	BEQ	.5
.3:
	DEX
	BPL	.2
.31:
	LDA	TEMP+1
	CLC
	ADC	#$10
	STA	TEMP+1
	LDX	TEMP
	LDA	TEMP+3
	STA	TOTLIN,X
	CMP	CURLIN,X
	BCS	.4
	STA	CURLIN,X
.4:
	INX
	STX	TEMP
	CPX	#$06
	BNE	.1
	LDA	#$00
	STA	TOTLIN,X
	RTS
.5:
	TXA
	STA	PLYTAB,Y
	INY
	INC	TEMP+3
	BNE	.3
****
*
* PROGRAM TO HANDLE COLOR DECREMENT FOR SCREEN FADE OUT
*
****
CON1:
	LDA	FRMCNT
	BNE	.4		;CHECK IF FRMCNT =0 ELSE SKIP
	LDA	COLOR
	AND	#$0F
	BNE	.1		;IF COLOR = 0 THEN NO DECREMENT
	LDA	COLOR+1
	AND	#$0F
	BNE	.2		;IF BOTH COLORS = 0 THEN SET MODE 2
	LDA	CONTRL
	AND	#$F0
	ORA	#$02
	STA	CONTRL
	BNE	.4
.1:
	DEC	COLOR
	LDA	COLOR+1 	;SHOULD CHECK COLOR+1 HERE ALSO
	AND	#$0F
	BEQ	.3
.2:
	DEC	COLOR+1
.3:
	LDA	#$03		;IF COLOR DECREMENTED THEN RESET TIMER
	STA	FRMCNT
.4:
	JSR	SETPLAY 	;CALL SETPLAY AND EXIT TO END OF OVERSCAN
	JMP	OVER
****
*
* PROGRAM TO GOTO NEXT ROOM MODE = 3
*
****
CON3:
	LDA	HEALTH
	AND	#$1F		;MASK OUT OTHER BITS
	BNE	.2
	LDA	PLAY
	LSR
	BCC	.1
	LDA	HEALTH+1
	AND	#$1F		;MASK OUT
	BNE	.2
.1:	
	LDA	#$80
	STA	FRMCNT	 
	LDA	CONTRL
	AND	#$F0
	ORA	#$07
	STA	CONTRL		;IF BOTH DEAD OR NOT ENABLED THEN GAME OVER
	JMP	OVER
.2:
	LDA	PLHOR+SARA
	BMI	.5		;IF NEXT LEVEL JMP TO ITS CODE
	LDX	ROOM
	LDA	EXITYP,X	;GET EXIT INFORMATION FOR ROOM
	ASL
	ASL
	ASL
	ADC	PLHOR+SARA	;GET OFFSET FROM EXIT NUMBER
	TAY
	LDA	EXIT0,Y
	CLC
	ADC	ROOM
	STA	ROOM
	LDX	PLHOR+SARA	;GET START X,Y LOCATION ON ENTRY IN ROOM
	LDY	YSTART,X
	LDA	HEALTH
	AND	#$1F		;MASK OUT STATUS
	BEQ	.3
	STY	PLVER		;IF HEALTH>0 THEN PUT ON SCREEN
.3:
	LDA	PLAY		;IF SECOND PLAYER ALIVE PUT ON SCREEN
	LSR
	BCC	.4
	LDA	HEALTH+1
	AND	#$1F
	BEQ	.4
	STY	PLVER+1
.4:
	LDA	RANDOM		;SET UP HORIZONTAL LOCATIONS
	AND	#$01		;RAMDOMIZE WHO IS IN FRONT
	TAY
	LDA	XSTART,X
	CLC
	ADC	ADDTAB,Y
	STA	PLHOR
	LDA	XSTART,X
	CLC
	ADC	ADDTAB+1,Y
	STA	PLHOR+1
	LDA	#$0C		;SET FACING DIRECTION
	STA	PLREF
	STA	PLREF+1
	LDA	#$16
	STA	PLTYP		;SET TYPE OF PLAYERS
	LDA	#$26
	STA	PLTYP+1
	LDA	CONTRL
	AND	#$F0
	ORA	#$05		;CONTROL = 5 (SKIPS ENTERING LEVEL SCREEN)
	STA	CONTRL
	JSR	UPWINDOW
	JMP	OVER
****
*
* SECTION TO HANDLE NEXT LEVEL 
*
****
.5:	
	LDA	PLAY		;IF BOTH ENABLED AND ONE IS DEAD
	AND	#$01		;TAKE HEALTH FROM OTHER PLAYER 
	BEQ	.7		;DIVIDE BY TWO AND PLACE INTO DEAD PLAYERS 
	LDA	HEALTH		;HEALTH
	AND	#$1F
	BNE	.6
	LDA	HEALTH+1
	AND	#$1F
	LSR
	ORA	#$01
	STA	HEALTH		;TAKE OUT STATUS OF PLAYER ALSO
	JMP	.7
.6:
	LDA	HEALTH+1
	AND	#$1F
	BNE	.7
	LDA	HEALTH
	AND	#$1F
	LSR
	ORA	#$01
	STA	HEALTH+1	;HEALTH= OTHER/2|1
.7:
	LDY	LEVEL		;GET LEVEL NUMBER FOR CURRENT ROOM
	INY
	CPY	#26		;CHECK IF PAST LEVEL Z (26)
	BNE	.8
	LDA	PLAY
	CLC
	ADC	#$02
	CMP	#$06
	BCS	.75
	STA	PLAY
.75:
	LDA	PLAY		;IF PAST LEVEL Z THEN INCREASE DIFFICULTY
	LSR			;AND GET STARTING LEVEL FOR NEXT DIFFICULTY
	TAY
	LDA	PLAYLEV,Y
	TAY
.8:
	STY	LEVEL		;STORE IN LOCATION FOR TITLE BANK
	LDA	ENTRYR,Y
	STA	ROOM		;FIND ROOM NUMBER FOR NEXT LEVEL
	STA	OBSTAT		;PUT ROOM NUMBER AS BEGINNING OF LEVEL
	LDA	#$FF
	STA	OBSTAT+1
	STA	OBSTAT+2	;ERASE LEVEL STATUS
	LDA	ENTRY,Y
	AND	#$F0
	TAX
	STX	PLVER
	LDA	PLAY
	LSR
	BCC	.9
	STX	PLVER+1 	;IF PLAYER TWO ENABLED THEN PUT ON SCREEN
.9:
	LDA	RANDOM		;RANDOMIZE POSITIONS OF PLAYERS
	AND	#$01
	TAX
	LDA	ENTRY,Y
	AND	#$07
	TAY
	LDA	ENTRYX,Y
	CLC
	ADC	ADDTAB,X
	STA	PLHOR
	LDA	ENTRYX,Y
	ADC	ADDTAB+1,X
	STA	PLHOR+1
	LDA	#$C0		;MAKE FACING DIRECTION LOOKING DOWN
	STA	PLREF
	STA	PLREF+1
	LDA	#$16
	STA	PLTYP
	LDA	#$26
	STA	PLTYP+1
	LDA	CONTRL
	AND	#$F0
	ORA	#$04
	STA	CONTRL		;SET MODE FOR ENTERING LEVEL SCREEN
	JSR	UPWINDOW
	JMP	OVER
	
****
*
* PROGRAM TO HANDLE COLOR FADE IN
*
****
CON6:
	LDA	FRMCNT		;FIRST CHECK TIMER
	BNE	.4
	LDA	#$02		;BACKGROUND = 02
	STA	TEMP+1
	LDA	ROOM		;PFCOLOR = LOW NIBBLE OF ROOM#
	ASL
	ASL
	ASL
	ASL
	STA	TEMP		;GET PLAYFIELD COLOR AND PUT AWAY
	LDA	ROOM
	LSR
	LSR
	LSR
	LSR
	TAX
	LDA	LUMLEV,X	;GET LUMINANCE VALUE OF LEVEL
	ORA	TEMP
	STA	TEMP
	LDA	COLOR+1
	AND	#$0F
	STA	TEMP+3		;SET HIGH NIBBLE TO STORED VALUE
	LDA	TEMP+1
	AND	#$F0
	ORA	TEMP+3
	STA	COLOR+1
	LDA	COLOR
	AND	#$0F
	STA	TEMP+2		;SET HIGH NIBBLE TO STORED VALUE
	LDA	TEMP
	AND	#$F0
	ORA	TEMP+2
	STA	COLOR
	CMP	TEMP		;CHECK IF COLORS ARE EQUAL
	BNE	.1		;IF = THEN NO INC AND CHECK OTHER ONE
	LDA	COLOR+1 	;CHECK IF BACKGROUND COLORS ARE EQUAL
	CMP	TEMP+1
	BNE	.2
	LDA	CONTRL
	AND	#$F0
	STA	CONTRL		;IF COLORS ARE BOTH EQUAL THEN RETURN TO 
	JSR	SETPLAY 	;NORMAL SCREEN MODE
	JMP	OVER
.1:
	INC	COLOR
	LDA	COLOR+1 	;CHECK COLOR+1 AGAIN TO SEE IF INC
	CMP	TEMP+1
	BEQ	.3
.2:
	INC	COLOR+1
.3:
	LDA	#$03		;SET TIMER AND EXIT
	STA	FRMCNT
.4:
	JSR	SETPLAY
	JMP	OVER
*
* UPDATE JOYSTICKS
*
UPJOY:
	LDX	MOTION
	DEX
	BPL	.1
	LDX	#$0F
.1:
	STX	MOTION
	LDX	SWCHA
	LDA	PLAY
	AND	#$01
	BEQ	.10
	LDY	PLVER+1+SARA
	BNE	.12
.10:
	LDA	#$00
	STA	PLDIR+1
	LDA	#$80
	STA	PLTYP+1
	LDA	HEALTH+1
	AND	#$1F
	BNE	.21		;CHECK IF DEAD
	LDA	HEALTH		;IF SO AND OTHER ALSO DEAD THEN SKIP
	AND	#$1F
	BEQ	.21
	LDA	KEYS+1		;ADD KEYS OF DEAD PERSON TO ALIVE PERSON
	AND	#$0F
	STA	TEMP+1
	LDA	KEYS
	AND	#$0F
	CLC
	ADC	TEMP+1
	CMP	#$10
	BCC	.11
	LDA	#$0F
.11:
	STA	TEMP+1
	LDA	KEYS
	AND	#$F0
	ORA	TEMP+1
	STA	KEYS
	LDA	KEYS+1
	AND	#$F0
	STA	KEYS+1		;ZERO OUT KEYS
	JMP	.21
.12:
	TXA
	AND	#$0F
	TAY
	LDA	DIRJOY,Y
	BNE	.2
	LDA	PLDIR+1+SARA
	AND	#$0B
	STA	PLDIR+1
	JMP	.21
.2:
	STA	PLDIR+1
	ASL
	ASL
	ASL
	STA	TEMP+1
	LDA	PLREF+1+SARA
	AND	#$0F
	ORA	TEMP+1
	STA	PLREF+1
.21:
	LDA	PLVER+SARA
	BNE	.25
	LDA	#$00
	STA	PLDIR
	LDA	#$80
	STA	PLTYP
	LDA	HEALTH
	AND	#$1F
	BNE	.31		;CHECK IF DEAD
	LDA	HEALTH+1	;IF SO AND OTHER ALSO DEAD THEN SKIP
	AND	#$1F
	BEQ	.31
	LDA	KEYS		;ADD KEYS OF DEAD PERSON TO ALIVE PERSON
	AND	#$0F
	STA	TEMP+1
	LDA	KEYS+1
	AND	#$0F
	CLC
	ADC	TEMP+1
	CMP	#$10
	BCC	.22
	LDA	#$0F
.22:
	STA	TEMP+1
	LDA	KEYS+1
	AND	#$F0
	ORA	TEMP+1
	STA	KEYS+1
	LDA	KEYS		;ZERO OUT DEAD PLAYER KEYS
	AND	#$F0
	STA	KEYS
	JMP	.31
.25:
	TXA
	LSR
	LSR
	LSR
	LSR
	TAY
	LDA	DIRJOY,Y
	BNE	.3
	LDA	PLDIR+SARA
	AND	#$0B
	STA	PLDIR
	JMP	.30
.3:
	STA	PLDIR
	ASL
	ASL
	ASL
	STA	TEMP+1
	LDA	PLREF+SARA
	AND	#$0F
	ORA	TEMP+1
	STA	PLREF
.30:
	JSR	TSTDIST 	;TEST DISTANCE BETWEEN PLAYERS
.31:
	LDA	PLVER+SARA
	BEQ	.4
	LDX	#0
	JSR	FARROW
	LDX	#0
	JSR	CKPF
	JSR	PLOBJ
	LDX	#$00
	JSR	CKOBJECT
	JSR	UPXY
	LDX	#0
	JSR	ANIPLAY
	LDX	#0
.4:
	LDA	PLVER+1+SARA
	BEQ	.5
	LDX	#$01
	JSR	FARROW
	LDX	#1
	JSR	CKPF
	JSR	PLOBJ
	LDX	#$01
	JSR	CKOBJECT
	JSR	UPXY
	LDX	#1
	JSR	ANIPLAY
	LDX	#$01
.5:
	JSR	CHKIT
	RTS
TSTDIST:
	LDA	PLVER+SARA
	BEQ	.2
	LDA	PLVER+1+SARA
	BEQ	.2
	LDX	PLDIR+1+SARA
	CLC
	ADC	VERTJOY,X
	STA	TEMP
	LDA	PLVER+SARA
	LDX	PLDIR+SARA
	CLC
	ADC	VERTJOY,X
	SEC
	SBC	TEMP
	BCS	.1
	EOR	#$FF
	ADC	#$01
.1:
	CMP	#54		;DISTANCE BETWEEN PLAYERS
	BCC	.2
	LDA	PLDIR+SARA
	AND	#$EF
	STA	PLDIR
	LDA	PLDIR+SARA+1
	AND	#$EF
	STA	PLDIR+1
.2:
	RTS
CHKIT:
	LDA	PLVER+SARA
	BEQ	.1
	LDA	PLVER+1+SARA	;BASED ON HEALTH
	BEQ	.0
	LDA	HEALTH+1
	AND	#$1F
	STA	IT
	LDA	HEALTH
	AND	#$1F
	CMP	IT
	BCC	.1
.0:
	LDA	#$00
	BEQ	.2
.1:
	LDA	#$01
.2:
	STA	IT
.3:
	RTS
****
*
* PROGRAM TO CHECK FIRE BUTTON
*
****
FARROW:
	LDA	ADIR,X
	AND	#$30
	BNE	.5
	LDA	ADIR,X
	AND	#$0F
	STA	ADIR,X		;SET MODE TO 0
	BNE	.3
	LDA	#$00
	STA	BALCNT+1,X	;IF TIMER =0
.0:
	LDA	$C,X
	BPL	.2
.1:
	RTS
.2:
	LDA	PLREF+SARA,X
	AND	#$A0
	BEQ	.1
	LDA	PLREF+SARA,X	;SET DIRECTION AND TIMER TO 3
	LSR
	LSR
	LSR
	LSR
	ORA	#$30
	STA	ADIR,X
	LDA	PLHOR+SARA,X
	STA	HMBALL+1,X
	LDA	PLVER+SARA,X
	STA	BALCNT+1,X
	LDA	#BULLET-AUDTAB
	STA	SOUND0
.3:
	LDY	$C,X
	BMI	.4
	LDA	#$00
	STA	PLDIR,X
.4:
	RTS
.5:	LDA	ADIR,X		;IF TIMER <>0 THEN STATE
	BMI	.7		;IF STATE = 0
	LDY	$C,X		;IF BUTTON UP THEN SET NEXT STATE
	BPL	.6
	ORA	#$B0		;IF STATE=0 AND BUTTON UP THEN STATE=1
	STA	ADIR,X
	RTS			;AND TIMER IS RESET
.6:
	AND	#$30		;MASK OUT THREE BITS
	SEC
	SBC	#$10		;SUBTRACT NUMBER
	STA	TEMP
	LDA	ADIR,X
	AND	#$8F
	ORA	TEMP
	STA	ADIR,X
	JMP	.3
.7:
	LDA	$C,X
	BMI	.6		;IF BUTTON UP THEN JUST DEC TIMER
	LDA	KEYS,X
	AND	#$F0
	BEQ	.6
	LDA	#BOMB-AUDTAB
	STA	SOUND0+1
	LDA	#$00
	STA	ADIR,X
	STX	TEMP
	LDY	#$05
.8:
	LDA	PLTYP+SARA,Y	;KILL PLAYER
	LSR
	LSR
	LSR
	LSR
	TAX
	LDA	SCORES-3,X	  ;ADD SCORE OF WHAT HE IS NOW
	STA	TEMP+1
	LDA	#$86
	STA	PLTYP,Y
	LDX	TEMP
	SED
	LDA	SCORLO,X
	CLC
	ADC	TEMP+1
	STA	SCORLO,X
	LDA	SCORHI,X
	ADC	#$00
	STA	SCORHI,X
	CLD
	DEY
	CPY	#$01
	BNE	.8
	LDY	#$09
.9:
	LDA	PLTYP+SARA,Y	;CHECK IF GENERATOR
	CMP	#$0F
	BNE	.10
	LDA	PLREF+SARA,Y
	LSR
	LSR
	LSR
	LSR
	STA	PLTYP,Y 	;PUT TYPE THAT GENERATOR MAKES
	BNE	.9A
	STA	PLVER,Y
.9A:
	LDA	#$10		;IF KILL GENERATOR THEN ADD SCORE 100 PTS
	SED
	CLC
	ADC	SCORLO,X
	STA	SCORLO,X
	LDA	SCORHI,X
	ADC	#$00
	STA	SCORHI,X
	CLD
.10:
	DEY
	CPY	#$05
	BNE	.9
	LDA	#$00
	STA	PLDIR,X
	LDA	KEYS,X
	SEC
	SBC	#$10
	BCS	.10A
	LDA	KEYS,X		;IF NUMBER <#$10 THEN BOMBS = 0
	AND	#$0F
.10A:
	STA	KEYS,X		;DEC BOMB
	RTS	 
****
*
* PROGRAM TO CHECK PLAYER AGAINST OBJECT
*
****
CKOBJECT:
	LDA	PLREF+SARA,X
	AND	#$FE
	STA	PLREF,X 	;CANCEL DOWNSTAIRS BIT OF PLAYER
	LDA	TEMP+2
	BMI	.01
	CMP	#$06
	BCS	.1
.01:
	RTS
.1:
	TAY
	PHA
	LDA	PLTYP+SARA,Y
	AND	#$0F
	TAY
	LDA	GETLO,Y
	STA	TEMP+2
	LDA	GETHI,Y
	STA	TEMP+3
	PLA
	TAY
	LDA	PLTYP+SARA,Y
	JMP	(TEMP+2)
* DOWNSTAIRS
GSTAIR:
	LDA	PLREF+SARA,X	;SET LSB TO FLAG DOWNSTAIRS TOUCHED
	ORA	#$01
	STA	PLREF,X
	RTS
* KEYHOLE
GHOLE:
	LDA	KEYS,X
	AND	#$0F
	BEQ	GEXIT2
	SEC
	SBC	#$01
	STA	TEMP+3
	LDA	KEYS,X
	AND	#$F0
	ORA	TEMP+3
	STA	KEYS,X
	JMP	GEXIT
* KEY
GKEY:
	LDA	KEYS,X		;IF NO KEYS THEN NO GO THROUGH
	AND	#$0F
	CLC
	ADC	#$01
	CMP	#$10		;IF 15 KEYS ALREADY THE NO PICKUP
	BEQ	GEXIT2
	STA	TEMP+3
	LDA	KEYS,X
	AND	#$F0
	ORA	TEMP+3
	STA	KEYS,X
	BNE	GEXIT
* BOMB
GBOMB:
	LDA	KEYS,X
	CLC
	ADC	#$10
	BCS	GEXIT2		;IF 15 BOMBS ALREADY THEN NO PICKUP
	STA	KEYS,X
	BNE	GEXIT
* FOOD
GFOOD:
	LDA	HEALTH,X
	AND	#$E0
	STA	TEMP+3
	LDA	HEALTH,X
	AND	#$1F
	CLC
	ADC	#$04
	CMP	#$20
	BCS	GEXIT2		;IF FULL CANNOT EAT FOOD
	ORA	TEMP+3
	STA	HEALTH,X
* EXIT PROGRAM PORTION
GEXIT:
	LDA	#PICKUP-AUDTAB
	STA	SOUND0
GEXIT1:
	LDA	#$00
	STA	PLVER,Y
	LDA	#$80
	STA	PLTYP,Y
GEXIT2:
	RTS
* TRAP, POISON
GTRAP:
	STY	TEMP+2
	TAY
	LDA	HEALTH,X
	AND	#$E0
	STA	TEMP+3
	LDA	HEALTH,X
	AND	#$1F
	SBC	TRAPDRAN-8,Y
	BMI	.1
	BNE	.2
.1:
	LDA	#$86
	STA	PLTYP,X
	LDA	#$00
.2:
	ORA	TEMP+3
	STA	HEALTH,X
	LDA	#PLAYERHIT-AUDTAB
	STA	SOUND0
	LDY	TEMP+2
	BNE	GEXIT1
*GUN, DAGGER, SHIELD
GGUN:
	STY	TEMP+2
	TAY
	LDA	ATRIBUTE-5,Y
	TAY
	AND	HEALTH,X	;IF ALREADY HAS IT THEN NO PICKUP
	BNE	GEXIT2
	TYA
	ORA	HEALTH,X
	STA	HEALTH,X
	LDY	TEMP+2
	BNE	GEXIT
* CHEST, CHALACE, AMULET
GCHEST:
	STY	TEMP+2
	TAY
	LDA	OBJSCLO-1,Y
	SED
	CLC
	ADC	SCORLO,X
	STA	SCORLO,X
	LDA	OBJSCHI-1,Y
	ADC	SCORHI,X
	STA	SCORHI,X
	CLD
	LDY	TEMP+2
	BNE	GEXIT
****
*
* PROGRAM TO ANIMATE PLAYER GIVEN INDEX OF PLAYER
*
*  X = INDEX OF PLAYER
****
ANIPLAY:
	LDA	PLDIR+SARA,X
	LSR
	TAY
	LDA	PLJOY,Y
	BPL	.1
	LDA	PLREF+SARA,X	;IF PLAYER NOT MOVING GET LAST MOVEMENT
	LSR
	LSR
	LSR
	LSR
	TAY
	LDA	PLJOY,Y
	AND	#$7F
	BPL	.2
.1:
	LDA	MOTION
	AND	#$07
	CLC
	ADC	PLJOY,Y
.2:
	STY	TEMP+1
	JMP	ANEM1
UPGUYS:
	LDX	#$01
.0:
	LDA	PLDIR+SARA,X	; STORE DIRECTION INTO NEWDIR
	TAY
	LDA	HORIJOY,Y	; STORE VECTORS INTO NEWX1, NEWY1
	CLC
	ADC	PLHOR+SARA,X
	STA	PLHOR,X
	LDA	VERTJOY,Y
	CLC
	ADC	PLVER+SARA,X
	STA	PLVER,X
	DEX
	BPL	.0
	LDA	MOTION
	AND	#$01
	BNE	.2
	LDX	#$05
.1:
	LDA	PLDIR+SARA,X	; STORE DIRECTION INTO NEWDIR
	TAY
	LDA	HORIJOY,Y	; STORE VECTORS INTO NEWX1, NEWY1
	CLC
	ADC	PLHOR+SARA,X
	STA	PLHOR,X
	LDA	VERTJOY,Y
	CLC
	ADC	PLVER+SARA,X
	STA	PLVER,X
	DEX
	CPX	#$03
	BNE	.1
	BEQ	.25
.2:
	LDX	#$03
.21:
	LDA	PLDIR+SARA,X	; STORE DIRECTION INTO NEWDIR
	TAY
	LDA	HORIJOY,Y	; STORE VECTORS INTO NEWX1, NEWY1
	CLC
	ADC	PLHOR+SARA,X
	STA	PLHOR,X
	LDA	VERTJOY,Y
	CLC
	ADC	PLVER+SARA,X
	STA	PLVER,X
	DEX
	CPX	#$01
	BNE	.21
.25:
	LDA	#$00
UPWINDOW:
	STA	TEMP+2		;IF RAN FROM CON THEN MAKE WINDOW JUMP
	LDA	PLVER+1+SARA
	BNE	.27
	LDA	PLVER+SARA
	BNE	.4
	RTS			;IF BOTH DEAD THEN LEAVE WINDOW ALONE
.27:
	LDA	PLVER+SARA
	BNE	.29
	LDA	PLVER+1+SARA
	JMP	.4
.29:
	SEC
	SBC	PLVER+1+SARA
	BCS	.3
	EOR	#$FF
	ADC	#$01
	LSR
	CLC
	ADC	PLVER+SARA
	BCC	.4
.3:
	LSR
	CLC
	ADC	PLVER+1+SARA
.4:
	SEC
	SBC	#26
	BEQ	.45
	BCS	.5
.45:
	LDA	#$01
	STA	WINDOW
.5:
	CMP	#$C1
	BCC	.6
	LDA	#$C1
.6:
	LDX	TEMP+2		;CHECK IF SMOOTH SCROLL WINDOW
	BEQ	.8
	STA	WINDOW
.7:
	RTS
.8:
	LDX	#$01
	CMP	WINDOW
	BEQ	.7
	BCS	.9
	LDX	#$FF
.9:
	TXA
	CLC
	ADC	WINDOW
	STA	WINDOW
	RTS
CKGENER:
	STX	VTEMP+1
	LDA	LEVEL
	LSR
	AND	#$0C
	STA	VTEMP+2
	LDA	PLAY
	LSR
	ORA	VTEMP+2
	TAX
	LDA	GENSPEED,X
	STA	VTEMP+2
	LDA	MUTATE,X
	STA	VTEMP+3
	LDX	#$09
.1:
	LDA	PLTYP+SARA,X	;FIND GENERATOR (5)
	CMP	#$0F
	BEQ	.3
.2:
	INC	RANDOM
	DEX
	CPX	#$05
	BNE	.1
	RTS
.3:
	LDA	RANDOM		;BASED ON RANDOM, LEVEL AND PLAY
	AND	VTEMP+2
	BNE	.2
	INC	RANDOM
	LDY	#$05
.4:
	LDA	PLVER+SARA,Y	;FIND A DEAD ENEMY
	BEQ	.5
	DEY
	CPY	#$01
	BNE	.4
	RTS
.5:
	LDA	PLHOR+SARA,X
	STA	PLHOR,Y
	LDA	PLVER+SARA,X
	STA	PLVER,Y
	TXA
	SEC
	SBC	#$06
	CLC
	ADC	VTEMP+3
	TAX
	LDA	GENGUY,X	;TABLE CONTAINS 16 TYPES OF GUYS
	TAX
	AND	#$F0
	STA	PLTYP,Y 	;UPPER NIBBLE IS TYPE
	TXA
	AND	#$0F
	STA	VTEMP
	LDA	RANDOM
	AND	#$F0
	ORA	VTEMP		;LAUNCH IN RANDOM DIRECTION
	STA	PLREF,Y 	;LOWER NIBBLE IS HITS
	JMP	GETRAND 	;GET NEW RANDOM NUMBER		
****
*
* CKPF
*
* PROGRAM TO CHECK PLAYER GIVEN TO THE PLAYFIELD TO SEE IF A COLLISION
*  IS TAKING PLACE.
*
* ON ENTRY X = PLAYER INDEX
*
* ON EXIT Z = 0 COLLISION
*	  Z = 1 NO COLLISION
*
* PROGRAM WILL GET THE DIRECTION OF PLAYER AND CHECK TO PLAYFIELD
*  ON EXIT NEW DIRECTION WILL BE STORED ACCORDING TO COLLISIONS
*
*  USES TEMP - 4
****
CKPF:
	STX	TEMP
	LDA	PLTYP+SARA,X
	BPL	.0
	JMP	.10
.0:
	LDA	WINDOW
	SEC
	SBC	#$01
	AND	#$FC
	STA	TEMP+4		;STORE WINDOW VALUE AWAY MASK BITS 01 OUT
	LDA	PLDIR+SARA,X
	STA	NEWDIR
	TAY
	LDA	PLVER+SARA,X	;STORE OLD VALUES OF POSITION INTO NEWX,NEWY
	STA	NEWY
	CLC
	ADC	VERTJOY,Y
	STA	NEWY1
	LDA	PLHOR+SARA,X
	STA	NEWX
	CLC
	ADC	HORIJOY,Y
	STA	NEWX1
	LDA	NEWDIR
	AND	#$10
	BEQ	.7
	LDA	NEWY1
	CMP	#$00
	BNE	.1
	LDA	NEWDIR
	AND	#$0F
	STA	NEWDIR
	JMP	.7
.1:
	LDA	#$00
	STA	TEMP+1		; MAKE MASKS FOR 3 DOTS IN VERTICAL CHECK
	STA	TEMP+2
	STA	TEMP+3
	LDA	#$01
	JSR	VERTCHK 	; CHECK 2 DOTS ALONG VERTICAL SIDE OF PLAYER
	LDA	#$06
	JSR	VERTCHK
	LDA	NEWDIR		; CHECK IF UP/ DOWN
	LDX	#$09
	AND	#$08
	BEQ	.3
	LDX	#$10		; UP = 8 DOWN = F
.3:
	TXA
	CLC
	ADC	NEWY1		; CHECK MASKS IN PF  TEMP+1 = PF0MASK
	SBC	TEMP+4		;OFFSET IN WINDOW
	CMP	#$4C
	BCC	.31		;IF >0 AND <76 OK
	LDA	RANDOM
	AND	#$1F
	BNE	.6
	INC	RANDOM
	LDA	#$86
	LDX	TEMP
	STA	PLTYP,X 	;IF OFF SCREEN KILL HIM???
	BNE	.10
.31:
	LSR			;   TEMP+2 = PF1MASK
	LSR			;   TEMP+3 = PF2MASK
	TAY
	LDA	TEMP+1
	BEQ	.4
	AND	RAMPF0+SARA,Y
	BNE	.6
.4:
	LDA	TEMP+2
	BEQ	.5
	AND	RAMPF1+SARA,Y
	BNE	.6
.5:
	LDA	TEMP+3
	BEQ	.7
	AND	RAMPF2+SARA,Y
	BEQ	.7
.6:
	LDA	#$0F
	AND	NEWDIR		; IF COLLISION THEN CLEAR UP/DOWN BIT
	STA	NEWDIR		; ALSO BRING Y VECTOR BACK
	LDA	NEWY
	STA	NEWY1
.7:
	LDA	NEWDIR
	AND	#$04		; CHECK FOR HORIZONTAL MOVEMENT
	BEQ	.10
	LDX	#$01
	LDA	NEWDIR
	AND	#$02
	BEQ	.8
	LDX	#$06
.8:
	LDA	NEWX1
	CMP	#153
	BCS	.9		;CHECK IF OFF SCREEN
	STX	TEMP+1
	LDA	#$09
	JSR	PFCHK		; CHECK FOR THREE POINTS IN LEFT/ RIGHT SIDE
	BNE	.9
	LDX	TEMP+1
	LDA	#$0C
	JSR	PFCHK
	BNE	.9
	LDX	TEMP+1
	LDA	#$10
	JSR	PFCHK
	BEQ	.10
.9:
	LDA	#$1B		; IF COLLISION THEN CLEAR LEFT/ RIGHT BIT
	AND	NEWDIR
	STA	NEWDIR
	LDA	NEWX
	STA	NEWX1
.10:
	RTS
UPXY:
	LDX	TEMP
	LDA	NEWDIR		; PUT DIRECTION IN TABLE
	CMP	PLDIR+SARA,X	; CHECK IF MOVEMENT
	STA	PLDIR,X
	RTS
****
*
* PROGRAM TO GET MASKS FOR VERTICAL CHECK
*
* ON ENTRY A = OFFSET FROM NEWX1
*
****
VERTCHK:
	CLC
	ADC	NEWX		; ADD OFFSET TO NEW X POSISION
	LSR
	LSR
	CMP	#20		; CHECK IF ON RIGHT SIDE
	BCC	.1
	EOR	#$FF
	ADC	#39
.1:
	TAX			; CHECK IF IN PF0 MASK
	LDA	PF0MSK,X
	BEQ	.2
	ORA	TEMP+1		; IF SO THEN OR THEM TOGETHER
	STA	TEMP+1
	RTS
.2:
	LDA	PF1MSK,X
	BEQ	.3
	ORA	TEMP+2
	STA	TEMP+2
	RTS
.3:
	LDA	PF2MSK,X
	ORA	TEMP+3
	STA	TEMP+3
	RTS
****
*
* PROGRAM TO CHECK DOT IN PF
*
* ON ENTRY A = Y OFFSET FROM NEWY1
*	   X = X OFFSET FROM NEWX1
* ON EXIT  A = 00 NO COLLISION	FF = COLLISION
*
****
PFCHK:
	CLC
	ADC	NEWY1		; ADD OFFSET TO NEW Y
	SBC	TEMP+4		;GET OFFSET FROM WINDOW
	CMP	#$4C		;IF > SCREEN THEN COLLISION
	BCS	.5 
	LSR
	LSR
	TAY
	TXA
	CLC
	ADC	NEWX1
	LSR
	LSR
	CMP	#20		; GET RIGHT SIDE FIXED
	BCC	.1
	EOR	#$FF
	ADC	#39
.1:
	TAX
	LDA	PF0MSK,X	; CHECK DOTS IN MASK TO PF
	BEQ	.2
	AND	RAMPF0+SARA,Y
	BNE	.5
	RTS
.2:
	LDA	PF1MSK,X
	BEQ	.3
	AND	RAMPF1+SARA,Y
	BNE	.5
	RTS
.3:
	LDA	PF2MSK,X
	BEQ	.4
	AND	RAMPF2+SARA,Y
	BNE	.5
.4:
	LDA	#$00
	RTS
.5:
	LDA	#$FF
	RTS
PLOBJ:
	LDY	#$09
	LDA	NEWDIR
	AND	#$14
	BEQ	.6
.1:
	LDA	PLVER+SARA,Y
	BEQ	.4
	LDA	NEWY1
	SEC
	SBC	PLVER+SARA,Y
	BCS	.2
	EOR	#$FF
	ADC	#$01
.2:
	AND	#$F8
	BNE	.4
	LDA	NEWX1
	SEC
	SBC	PLHOR+SARA,Y
	BCS	.3
	EOR	#$FF
	ADC	#$01
.3:
	AND	#$F8
	BEQ	.5
.4:
	DEY
	CPY	#$05
	BNE	.1
	STY	TEMP+2
	RTS
.5:
	STY	TEMP+2
	LDA	#$00
	STA	NEWDIR
	RTS
.6:
	LDA	#$FF
	STA	TEMP+2
	RTS
****
*
*  PROGRAM TO UPDATE DIRECTIONS OF ENEMY GUYS
*
*  IF OLDDIR==DIR TRACK "IT" IN ONE DIRECTION
*  IF OLDDIR!=DIR && DIR !=0 CONTINUE IN GIVEN DIRECTION
*  IF OLDDIR!=DIR && DIR==0 FLIP ONE DIRECTION
*
****

ENEMYUP:
	LDA	MOTION
	AND	#$01
	BNE	.2
	LDX	#$05
.1:
	JSR	ENEMYUP1
	DEX
	CPX	#$03
	BNE	.1
	BEQ	.4
.2:
	LDX	#$03
.3:
	JSR	ENEMYUP1
	DEX
	CPX	#$01
	BNE	.3
.4:
	LDA	#$00
	STA	FRAME
	JMP	OVER
ENEMYUP1:
	LDA	PLVER+SARA,X	   
	BNE	.0  
	JSR	CKGENER
	LDX	VTEMP+1
	RTS
.0:
	LDA	PLREF+SARA,X	;MSB OF REF IS OLD DIRECTION
	LSR
	LSR  
	LSR
	LSR
	STA	VTEMP
	AND	#$0A
	STA	VTEMP+1
	BEQ	.1
	LDA	PLDIR+SARA,X
	LSR	
	AND	#$0A		;MASK OUT OTHER BITS
	CMP	VTEMP+1 	;CHECK IF OLD = CURRENT (NO COLLISION HIT)	
	BEQ	.2
	CMP	#$00		;CHECK IF CURRENT = 0 (GUY STUCK)
	BEQ	.1
	LDA	VTEMP		;IF COLLISION BUT NOT STUCK THEN
	ASL			;KEEP OLD DIRECTION UNTIL STUCK OR NO COLL
	BNE	.10
.1:	
	LDA	RANDOM		;IF STUCK CHOOSE DIRECTION TO CHANGE AND
	AND	#$01		;REVERSE DIRECTION 
	TAY
	LDA	VTEMP
	EOR	RSEED,Y 	;INVERT DIRECTION BIT	
	ORA	RSEED+2,Y	;SET DIRECTION ENABLE BIT
	BNE	.10
.2:	
	LDA	LEVEL
	LSR
	AND	#$0C
	STA	VTEMP+2
	LDA	PLAY
	LSR
	ORA	VTEMP+2
	TAY
	LDA	GENSPEED,Y
	AND	#$0F
	AND	RANDOM
	BNE	.11	
	LDY	IT		;IF NO COLLISION THEN CHOOSE DIRECTION TO 
	LDA	RANDOM		;TRACK TO "IT" 
	LSR
	BCS	.6
	LDA	PLHOR+SARA,X	;TRACK ON HORIZONTAL DIRECTION OF "IT"
	CMP	PLHOR+SARA,Y
	BNE	.3
	LDA	#$00		;IF HORIZONTALS ARE EQUAL NO DIRECTION
	BEQ	.5
.3:	
	BCC	.4
	LDA	#$04		;IF ENEMY IS > THEN LEFT DIRECTION
	BNE	.5
.4: 
	LDA	#$06		;IF ENEMY IS < THEN RIGHT DIRECTION
.5:
	STA	VTEMP
	LDA	PLDIR+SARA,X
	AND	#$18		;MASK OUT LEFT/RIGHT BITS
	ORA	VTEMP		;SET PROPER BITS FOR DIRECTION
	JMP	.10
.6:	
	LDA	PLVER+SARA,X	;TRACK ON VERTICAL DIRECTION OF "IT"
	CMP	PLVER+SARA,Y
	BNE	.7
	LDA	#$00		;IF VERTICALS ARE EQUAL NO DIRECTION
	BEQ	.9
.7:	
	BCC	.8  
	LDA	#$10		;IF ENEMY IF > THEN UP DIRECTION
	BNE	.9
.8:	
	LDA	#$18		;IF ENEMY IF < THEN DOWN DIRECTION
.9:	
	STA	VTEMP
	LDA	PLDIR+SARA,X
	AND	#$06		;MASK OUT UP/DOWN BITS
	ORA	VTEMP		;SET PROPER BITS FOR DIRECTION
.10:   
	AND	#$1E
	STA	PLDIR,X 	;PUT OLD DIRECTION INTO REFLECTION
	ASL
	ASL
	ASL
	STA	VTEMP
	LDA	PLREF+SARA,X
	AND	#$0F
	ORA	VTEMP
	STA	PLREF,X
.11:
	STX	VTEMP
	JSR	GETRAND
	JSR	CKPF		;CHECK PLAYFIELD COLLISION
****
*
* PROGRAM TO CHECK PLAYER GIVEN IN X 
* ON EXIT TEMP+2=PLAYER HIT
*
****
ENPL:
	LDA	NEWDIR
	AND	#$14
	BNE	.0
	JMP	.13
.0:
	LDA	MOTION
	LSR
	AND	#$01
	TAX
	LDA	PLVER+SARA,X
	BNE	.1
	JMP	.13		;IF PLAYER IS GONE THEN DONT CHECK
.1:
	LDA	NEWY1
	SEC
	SBC	PLVER+SARA,X
	BCS	.2
	EOR	#$FF
	ADC	#$01
.2:
	AND	#$F8
	BNE	.13
	LDA	NEWX1
	SEC
	SBC	PLHOR+SARA,X
	BCS	.3
	EOR	#$FF
	ADC	#$01
.3:
	AND	#$F8
	BNE	.13
	STA	NEWDIR
	LDY	VTEMP
	LDA	PLTYP+SARA,Y
	BMI	.13
	LSR
	LSR
	LSR
	LSR
	TAY
	LDA	HEALTH,X
	AND	#$E0		;SAVE STATUS BITS
	STA	TEMP+3
	ASL			;SHIFT SHIELD BIT INTO CARRY
	ASL
	LDA	ENEMDRAN-3,Y	;GET DRAIN AMOUNT
	BCC	.4
	LSR
.4:
	STA	TEMP+2		;STORE DRAIN AMOUNT
	LDA	HEALTH,X
	AND	#$1F		;EXTRACT HEALTH
	SEC
	SBC	TEMP+2		;SUB DRAIN
	BMI	.5
	BNE	.12
.5:
	LDA	#$86
	STA	PLTYP,X
	LDA	#$00		;IF HEALTH <=0 THEN DEAD PLAYER
.12:
	ORA	TEMP+3
	STA	HEALTH,X	 
	LDY	VTEMP
	LDA	PLTYP+SARA,Y
	LSR
	LSR
	LSR
	LSR
	TAX
	LDA	#$86
	DEX
	CPX	#$02
	BEQ	.121
	TXA
	ASL
	ASL
	ASL
	ASL
	STA	TEMP+2
	LDA	PLTYP+SARA,Y
	AND	#$0F
	ORA	TEMP+2
.121:
	STA	PLTYP,Y
	LDA	#PLAYERHIT-AUDTAB
	STA	SOUND0+1
.13:
	JSR	UPXY
	LDX	VTEMP
****
*
* PROGRAM TO ANIMATE ENEMY GUY GIVEN INDEX OF PLAYER
*
*  X = INDEX OF PLAYER
****
ANIENEMY:
	LDA	PLDIR+SARA,X
	LSR
	TAY
	LDA	PLJOY,Y
	BPL	.1
	AND	#$7F
	BPL	.2
.1:
	LDA	MOTION
	LSR
	CLC
	ADC	PLJOY,Y
.2:
ANEM1:
	TAY
	LDA	PLTYP+SARA,X
	BPL	.4
	CMP	#$80
	BNE	.3
	LDA	#$00
	STA	PLVER,X
	LDA	#$81
.3:
	SEC
	SBC	#$01
	STA	PLTYP,X
	LDA	#$00
	STA	PLDIR,X
	STA	PLREF,X
	RTS
.4:
	AND	#$F0
	ORA	PL,Y
	STA	PLTYP,X
	AND	#$0F
	TAY
	LDA	PLREF+SARA,X
	AND	#$F7
	ORA	PREFTAB,Y
	STA	PLREF,X
	RTS
****
*
* PROGRAM TO CHECK IF PLAYERS HAVE EXITED SCREEN AND HANDLE DOWNSTAIRS BIT
*
* THIS PROGRAM SETS THE MODE BYTE AND CAN REALLY CHANGE THINGS AROUND!
*
*
****
STLEVEL:
	LDX	ROOM		;SET UP VECTOR FOR EXIT TYPE ADDRESS
	LDA	EXITYP,X
	ASL
	ASL
	ASL
	STA	TEMP+4
	LDX	#$01
	JSR	CKPL		;FIND STATUS OF PLAYER 0
	STA	TEMP+3		;0 -DEAD OR NOT ENABLED
	LDX	#$00		;1 -OFF SCREEN
	JSR	CKPL1		;2 -ONSCREEN NOT IN EXIT
	ASL			;3 -ONSCREEN IN EXIT
	ASL			;ALSO TEMP,X = EXIT NUMBER
	ORA	TEMP+3
	TAX	
	LDA	WHATODO,X	;CONTAINS TABLE OF THINGS TO DO
	BEQ	.7		;0 -GAME OVER (BOTH DEAD)
				;1 -NOTHING
	CMP	#$01		;2 -NEXT ROOM P2
	BNE	.1		;3 -NEXT ROOM P1
	RTS			;4 -IF EXITS = NEXT ROOM ELSE NOTHING
.1:
	CMP	#$04		;5 -ERASE P2 FOR EXIT
	BNE	.2		;6 -ERASE P1 FOR EXIT
	LDA	TEMP
	CMP	TEMP+1
	BEQ	.6
	RTS
.2: 
	CMP	#$05
	BNE	.3
	LDX	#$01
	JMP	ERASET
.3:
	CMP	#$06
	BNE	.4
	LDX	#$00
	JMP	ERASET
.4:
	CMP	#$02
	BNE	.5
	LDA	TEMP+1
	JMP	.6
.5:
	LDA	TEMP
.6:
	STA	PLHOR
.7:
	LDA	CONTRL		;SET CONTROL FOR FADE OUT OF SCREEN
	AND	#$F0
	ORA	#$01
	STA	CONTRL
	LDA	#$00
	STA	SOUND0
	STA	SOUND0+1
	STA	ADIR
	STA	ADIR+1
	LDA	#$00
	STA	BALCNT+1
	STA	BALCNT+2
	STA	PLVER
	STA	PLVER+1
	LDA	#$03
	STA	FRMCNT		;SET FRMCNT TO # OF FRAMES TO WAIT
	RTS
GETRAND:
	LDA	RANDOM
	ROL
	EOR	FRMCNT
	ROL
	EOR	SWCHA
	ROL
	EOR	SWCHB
	STA	RANDOM
	RTS
****
*
* PROGRAM TO CHECK PLAYER TO EXIT
*
****
CKPL:	
	LDA	PLAY		;ENTRY POINT FOR PL2
	LSR
	BCC	CKPL2
CKPL1:
	LDA	PLREF+SARA,X	;ENTRY POINT FOR PL1
	AND	#$01		;CHECK IF DOWNSTAIRS BIT SET
	BEQ	.1
	LDA	#$FF		;IF SO THEN FF=EXIT NUMBER
	STA	TEMP,X
	BNE	.4
.1:
	LDA	PLVER+SARA,X
	BEQ	.6
	LDY	#$00
	LDA	PLHOR+SARA,X	;CHECK FOR LEFT (0-3)
	CMP	#1
	BEQ	.2
	LDY	#$04
	CMP	#152		;CHECK FOR RIGHT (0-4)
	BNE	.5
.2:
	STY	TEMP+2
	LDA	PLVER+SARA,X	;IF SO THEN ADD OFFSET FROM VERTICAL
	ROL			;(FOUR EXITS PER SIDE)
	ROL
	ROL
	AND	#$03
	ORA	TEMP+2
.3:
	STA	TEMP,X		;STORE EXIT NUMBER AWAY
	CLC
	ADC	TEMP+4
	TAY
	LDA	EXIT0,Y 	;CHECK IF EXIT ENABLED IF !=0 THEN OK
	BEQ	.5
	TYA
.4:
	LDA	#$03		;SET FOR ONSCREEN IN EXIT
	RTS
.5:
	LDA	#$02		;SET FOR ONSCREEN NOT IN EXIT
	RTS
.6:
	LDA	HEALTH,X	;WHEN PLVER=00 CHECK IF DEAD OR OFFSCREEN
	AND	#$1F
	BEQ	.7		;WHEN HEALTH=0 THEN DEAD
	LDA	PLHOR+SARA,X	;ELSE PUT EXIT NUMBER INTO TEMP
	STA	TEMP,X
	LDA	#$01		;SET FOR OFFSCREEN
	RTS
.7:
CKPL2:
	LDA	#$00		;SET FOR DEAD OR NOT ENABLED
	RTS
****
*
* PROGRAM TO ERASE PLAYER FROM SCREEN AND RETURN
*
****
ERASET:
	LDA	#$00		;DELETE PLAYER AND PUT EXIT NUMBER INTO 
	STA	PLVER,X 	;HORIZONTAL
	LDA	TEMP,X
	STA	PLHOR,X
	RTS		

      




